/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.adapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.resource.crate.ICountFunction;
import dev.toma.gunsrpg.resource.crate.LootEntry;
import dev.toma.gunsrpg.util.ModUtils;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import java.lang.reflect.Type;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class LootEntryAdapter
implements JsonDeserializer<LootEntry> {
    public LootEntry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = JsonHelper.asJsonObject(json);
        int weight = JSONUtils.func_151208_a((JsonObject)object, (String)"weight", (int)1);
        String itemId = JSONUtils.func_151219_a((JsonObject)object, (String)"item", null);
        if (ModUtils.isNullOrEmpty(itemId)) {
            throw new JsonSyntaxException("Invalid property value: 'item' must be defined and it's value cannot be empty");
        }
        ResourceLocation id = new ResourceLocation(itemId);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
        if (item == null || item == Items.field_190931_a) {
            throw new JsonSyntaxException(String.format("Invalid property value of 'item': '%s' is not a valid item id", itemId));
        }
        JsonObject countObj = JSONUtils.func_152754_s((JsonObject)object, (String)"count");
        ICountFunction function = (ICountFunction)context.deserialize((JsonElement)countObj, ICountFunction.class);
        return new LootEntry(weight, item, function);
    }
}

